#ifndef _IOTComm_H
#define _IOTComm_H

#if defined(ARDUINO) && (ARDUINO >= 100)
#include <Arduino.h>
#else
#include <WProgram.h>
#endif

#include "data.h"
#include <SoftwareSerial.h>
#include <stdio.h>

#define MAX_WIFISSID_LEN                32
#define MAX_WIFIPASSWORD_LEN            32
#define MAX_TOPIC_LEN                   64
#define MAX_DATA_LEN                    64
#define PUB_INTERVAL                    70
#define CFG_INTERVAL                    800
#define DEC                             10

const char PubMsgFlag                   = 'A';
const char SubMsgFlag                   = 'B';
const char ClientStatsFlag              = 'C';
const char TopicFlag                    = 'D';
const char WiFiNameFlag                 = 'E';
const char WiFiPasswordFlag             = 'F';
const char ServerAddressFlag            = 'G';
const char ProjectKeyFlag               = 'H';
const char ClientKeyFlag                = 'I';
const char ServerPortFlag               = 'J';
const char ServerLoginIDFlag            = 'K';
const char ServerLoginPasswordFlag      = 'L';
const char ConnectFlag                  = 'M';

class IOTCommClass {
  public:
    // constructor
    IOTCommClass(void);

    void setWifiName(char wifiname[]);
    void setWifiPassword(char wifipassword[]);
    void setProjectKey(char pjkey[16]);
    void setClientKey(byte ctkey[]);
    void setServerAddr(byte seraddr[]);
    void setServerPort(double portnum);
    void setServerLoginID(byte serid[]);
    void setServerLoginPassWord(byte serpw[]);
    void publishMsg(char topic[2], int data);
    void publishMsg(char topic[2], long data);
    void publishMsg(char topic[2], String data);
    void publishMsg(char topic[2], float data);
    void publishMsg(char topic[2], int data1,int data2);
    void publishMsg(char topic[2], uint8_t * data , int len);
    void publishStatus(char data[16]);
    
    void subscribeWebTopic(char topic[2]);
    void subscribeArduinoTopic(char topic[2]);  
    
    void connect();
    
    void setSerialPort(int rxd, int txd);
    void setserialBegin();
    
    int available();
    void listen();
    bool readMsg(char * mtopic, char * mpayload);
  private:
  	
  	int txdpin = 11;
		int rxdpin = 10;
		bool idleflag = true;
		SoftwareSerial iotserial = SoftwareSerial(rxdpin,txdpin); // RX, TX

  	void setDestTopicRootPath();
  	void setDestTopic(char usertopic[]);
  	
  	void setWebSrcTopicRootPath();
  	void setArduinoSrcTopicRootPath();
    void getWebSrcTopic(char * dest , char usertopic[2]);
    void getArduinoSrcTopic(char * dest , char usertopic[2]);
    	
    bool intToCharArray(int data1, int data2 , char * buf , int len);
    char read();
  	char m_projectkey[16] = {};
  	char m_desttopicrootpath[64] = {};
  	char m_srcwebtopicrootpath[64] = {};
  	char m_srcarduinotopicrootpath[64] = {};
  	 	
};
   
extern IOTCommClass IOTComm;    //defined in cubic.cpp

//union FloatBytes {
//  float f;
//  byte b[4];
//};

#endif
