'use strict';
goog.provide('Blockly.Blocks.BTarduino');
goog.require('Blockly.Blocks');

var TONE_NOTES=[["NOTE_D2", "131"],["NOTE_D3", "147"],["NOTE_E3", "165"],["NOTE_F3", "175"],["NOTE_G3", "196"],["NOTE_A3", "220"],["NOTE_B3", "247"],
           ["NOTE_C4", "262"],["NOTE_D4", "294"],["NOTE_E4", "330"],["NOTE_F4", "349"],["NOTE_G4", "392"],["NOTE_A4", "440"],["NOTE_B4", "494"],
           ["NOTE_C5", "532"],["NOTE_D5", "587"],["NOTE_E5", "659"],["NOTE_F5", "698"],["NOTE_G5", "784"],["NOTE_A5", "880"],["NOTE_B5", "988"]];
                                     
var incomming_Voice=[
["小树小树", "7777"],
["打开开关", "a111"],
["关闭开关","b111"],
["调亮一点","e222"],
["调暗一点","f222"],
["自我介绍一下","5555"],
["左转","c333"],
["右转","d333"],
["前进","b333"],
["后退","a333"],
["加快一点","e333"],
["变慢一点","f333"],
["启动Ａ一模式","a414"],
["启动Ｂ二模式","a424"],
["启动Ｃ三模式","a434"],
["启动Ｄ四模式","a444"],
];

var Brightness_level=[
["10%","1"],
["30%","2"],
["40%","3"],
["60%","4"],
["70%","5"],
["100%","6"],
];

var output_voice=[
["小树收到,请吩咐","0777"],
["开关已打开","a011"],
["开关已关闭","b011"],
["已经调亮 ","e022"],
["已经调暗","f022"],
["您好我叫小树来自树上科技请您吩咐","0555"],
["左转完毕","c033"],
["右转完毕","d033"],
["前进完毕","b033"],
["后退完毕","a033"],
["已加快","e033"],
["已变慢","f033"],
["Ａ一模式已启动","a014"],
["Ｂ二模式已启动","a024"],
["Ｃ三模式已启动","a034"],
["D四模式已启动","a044"],
["回答"," 0666"],
];

var byteleght=[
["1","1"],
["2","2"],
["3","3"],
["4","4"],
["5","5"],
["6","6"],
["7","7"],
["8","8"],
["9","9"],
["10","10"],
["11","11"],
["12","12"],
["13","13"],
["14","14"],
["15","15"],
["16","16"],
];
/////////////// CAM MU 

//siyang
var VOICE_PIN=[["老师", "0x00"],["爸爸", "0x01"],["妈妈", "0x02"],["爷爷", "0x03"],
               ["奶奶", "0x04"],["姥姥", "0x05"],["姥爷", "0x06"],["哥哥", "0x07"],
			   ["姐姐", "0x08"],["叔叔", "0x09"],["阿姨", "0x0A"],["上午", "0x0B"],
               ["下午", "0x0C"],["晚上", "0x0D"],["前方", "0x0E"],["厘米", "0x0F"],
               ["新年快乐", "0x10"],["身体健康", "0x11"],["工作顺利", "0x12"],["学习进步", "0x13"],
               ["您好", "0x14"],["谢谢", "0x15"],["的", "0x16"],["祝", "0x17"],
			   ["慢走", "0x18"],["欢迎光临", "0x19"],["亲爱的", "0x1A"],["同学们", "0x1B"],
			   ["工作辛苦了", "0x1C"],["点", "0x1D"],["打开", "0x1E"],["关闭", "0x1F"],
			   ["千", "0x20"],["百", "0x21"],["十", "0x22"],["1", "0x23"],
			   ["2", "0x24"],["3", "0x25"],["4", "0x26"],["5", "0x27"],
			   ["6", "0x28"],["7", "0x29"],["8", "0x2A"],["9", "0x2B"],
			   ["0", "0x2C"],["当前", "0x2D"],["转", "0x2E"],["左", "0x2F"],
			   ["右", "0x30"],["请", "0x31"],["已", "0x32"],["现在", "0x33"],
			   ["是", "0x34"],["红灯", "0x35"],["绿灯", "0x36"],["黄灯", "0x37"],
			   ["温度", "0x38"],["湿度", "0x39"],["欢迎常来", "0x3A"],["还有", "0x3B"],
			   ["秒", "0x3C"],["分", "0x3D"],["变", "0x3E"],["等", "0x3F"],
         ["下一次", "0x40"],["功能", "0x41"],["障碍物", "0x42"],["世界那么大，我想去看看", "0x43"]];
//siyang
var BT_VOICE_PIN=[["老师", "0x00"],["爸爸", "0x01"],["妈妈", "0x02"],["爷爷", "0x03"],
               ["奶奶", "0x04"],["姥姥", "0x05"],["姥爷", "0x06"],["哥哥", "0x07"],
			   ["姐姐", "0x08"],["叔叔", "0x09"],["阿姨", "0x0A"],["上午", "0x0B"],
               ["下午", "0x0C"],["晚上", "0x0D"],["前方", "0x0E"],["厘米", "0x0F"],
               ["新年快乐", "0x10"],["身体健康", "0x11"],["工作顺利", "0x12"],["学习进步", "0x13"],
               ["您好", "0x14"],["谢谢", "0x15"],["的", "0x16"],["祝", "0x17"],
			   ["慢走", "0x18"],["欢迎光临", "0x19"],["亲爱的", "0x1A"],["同学们", "0x1B"],
			   ["工作辛苦了", "0x1C"],["点", "0x1D"],["打开", "0x1E"],["关闭", "0x1F"],
			   ["千", "0x20"],["百", "0x21"],["十", "0x22"],["1", "0x23"],
			   ["2", "0x24"],["3", "0x25"],["4", "0x26"],["5", "0x27"],
			   ["6", "0x28"],["7", "0x29"],["8", "0x2A"],["9", "0x2B"],
			   ["0", "0x2C"],["当前", "0x2D"],["转", "0x2E"],["左", "0x2F"],
			   ["右", "0x30"],["请", "0x31"],["已", "0x32"],["现在", "0x33"],
			   ["是", "0x34"],["红灯", "0x35"],["绿灯", "0x36"],["黄灯", "0x37"],
			   ["温度", "0x38"],["湿度", "0x39"],["欢迎常来", "0x3A"],["还有", "0x3B"],
			   ["秒", "0x3C"],["分", "0x3D"],["变", "0x3E"],["等", "0x3F"],
         ["下次", "0x40"],["功能", "0x41"],["障碍物", "0x42"],["生日快乐", "0x43"],
         ["树上科技","0x44"],["今天","0x45"],["明天","0x46"],["昨天","0x47"],["中国","0x48"],
         ["小树","0x49"],["世界","0x4A"],["星期","0x4B"],["增加","0x4C"],
         ["减少","0x4D"],["你","0x4E"],["我","0x4F"]];


var lVisionCardType = [["🔳"+Blockly.LKL_VS2_VISION_SHAPE_CARD2, "VISION_SHAPE_CARD_DETECT"],
                      ["🔳"+Blockly.LKL_VS2_VISION_TRAFFIC_CARD2, "VISION_TRAFFIC_CARD_DETECT"],
                      ["🔳"+Blockly.LKL_VS2_VISION_NUM_CARD2, "VISION_NUM_CARD_DETECT"],
                      ];
var VS_VISION_TYPE = [["🌈 "+Blockly.LKL_VS2_VISION_COLOR_DETECT2, "VISION_COLOR_DETECT"],
                      ["🌈 "+Blockly.LKL_VS2_VISION_COLOR_RECOGNITION2, "VISION_COLOR_RECOGNITION"],
                      ["⚽ "+Blockly.LKL_VS2_VISION_BALL2, "VISION_BALL_DETECT"],
                      //["♎ "+Blockly.LKL_VS2_VISION_LINE, "VISION_LINE_DETECT"],
                      ["👥 "+Blockly.LKL_VS2_VISION_BODY2, "VISION_BODY_DETECT"],
                      // ["🔳 "+Blockly.LKL_VS2_VISION_SHAPE_CARD, "VISION_SHAPE_CARD_DETECT"],
                      // ["🔳 "+Blockly.LKL_VS2_VISION_TRAFFIC_CARD, "VISION_TRAFFIC_CARD_DETECT"],
                      // ["🔳 "+Blockly.LKL_VS2_VISION_NUM_CARD, "VISION_NUM_CARD_DETECT"],
                      // ["😉 "+Blockly.LKL_VS2_VISION_FACE, "VisionSensor::FACE"],
                      ].concat(lVisionCardType);

var SEN_VISION_Awb = [["自动白平衡","kAutoWhiteBalance"],
                      ["锁定白平衡","kLockWhiteBalance"],
                      ["白光模式","kWhiteLight"],
                      ["黄光模式","kYellowLight"],
]
var SEN_VISION_Zoom = [["1","1"],
                      ["2","2"],
                      ["3","3"],
                      ["4","4"],
                      ["5","5"],
]

var SEN_VISION_TYPE = [["颜色识别","Sentry::kVisionColor"],
                      ["色块检测","Sentry::kVisionBlob"],
                      ["线条检测","Sentry::kVisionLine"],
                      ["卡片检测","Sentry::kVisionCard"],
                      ["人脸检测","Sentry::kVisionFace"],
                      ["20类物体检测","Sentry::kVision20Classes"],

]


var SEN_VISION_COLOR = [["黑色","1"],
                        ["白色","2"],
                        ["红色","3"],
                        ["绿色","4"],
                        ["蓝色","5"],
                        ["黄色","6"],

]


var SEN_VISION_TYPE2 = [["人脸检测","Sentry::kVisionFace"],
]

var SEN_VISION_CARDTYPE = [["前进","1"],
                      ["左转","2"],
                      ["右转","3"],
                      ["掉头","4"],
                      ["停车","5"],
                      ["绿灯","6"],
                      ["红灯","7"],
                      ["限速40","8"],
                      ["限速60","9"],
                      ["限速80","10"],
                      ["对号","11"],
                      ["叉号","12"],
                      ["圆形","13"],
                      ["方形","14"],
                      ["三角形","15"],
                      ["加号","16"],
                      ["减号","17"],
                      ["除号","18"],
                      ["等于号","19"],
                      ["0","20"],
                      ["1","21"],
                      ["2","22"],
                      ["3","23"],
                      ["4","24"],
                      ["5","25"],
                      ["6","26"],
                      ["7","27"],
                      ["8","28"],
                      ["9","29"],
]
var SEN_VISION_CLASSTYPE = [["飞机","1"],
                      ["自行车","2"],
                      ["鸟","3"],
                      ["船","4"],
                      ["瓶子","5"],
                      ["公交车","6"],
                      ["小汽车","7"],
                      ["猫","8"],
                      ["椅子","9"],
                      ["牛","10"],
                      ["餐桌","11"],
                      ["狗","12"],
                      ["马","13"],
                      ["摩托车","14"],
                      ["人","15"],
                      ["盆栽植物","16"],
                      ["羊","17"],
                      ["沙发","18"],
                      ["火车","19"],
                      ["电视","20"],
]
var lVisionZoom = [[Blockly.LKL_VS2_AUTO,"kZoomDefault"],[Blockly.LKL_VS2_LEVEL+"1", "kZoom1"],
                  [Blockly.LKL_VS2_LEVEL+"2", "kZoom2"],[Blockly.LKL_VS2_LEVEL+"3", "kZoom3"],
                  [Blockly.LKL_VS2_LEVEL+"4", "kZoom4"],[Blockly.LKL_VS2_LEVEL+"5", "kZoom5"]
                  ];
// var lVisionLevel = [[Blockly.LKL_VS2_AUTO,"kLevelDefault"],
//                     [Blockly.LKL_VS2_HIGH_SPEED, "kLevelSpeed"],
//                     [Blockly.LKL_VS2_NORMAL, "kLevelBalance"],
//                     [Blockly.LKL_VS2_HIGH_ACCURACY, "kLevelAccuracy"],
//                     ];

var lVsMu = [["Mu01 (IIC)", "1"],["Mu00 (UART)","0" ]];
var Sentry = [["Sen01 (IIC)", "0"],["Sen00 (UART)", "1"]];
var portPin = [["Mu01 (IIC)", "1"],["Mu00 (UART)","0" ]];
// Blockly.Blocks.VisionSensor.HUE = "#EF5411";
// Blockly.Blocks.VisionSensor.HUE_SetupMode = "#EF5411";
// Blockly.Blocks.VisionSensor.HUE_RunMode = "#EAA20A";
var value = [["0","255" ],["10","220"],["100", "200"],["150", "160"],["160", "100"],["200", "70"],["220", "30"],["255", "0"]];
/////////////////////END CAM MU 

Blockly.makeColour = function(hue) {
  if (typeof hue == "string"){
      return hue;
  }
  return goog.color.hsvToHex(hue, Blockly.HSV_SATURATION,
      Blockly.HSV_VALUE * 390);
};
//Blockly.HSV_SATURATION // 0 (inclusive) to 1 (exclusive), defaulting to 0.45
// Blockly.HSV_VALUE // 0 (inclusive) to 1 (exclusive), defaulting to 0.65
var ControAlgorithm="#1ee89a";//comm block
var displaycolor="#ff87ed";//Display Block 
var controlcolor="#ffce54";
var aicolor="#70f96d";
var IOTcolor="#12aac9";
var Actuators="#ed87d3";
var ControAlgorithm="#1ee89a";
var testmodulecolor = "#00FFFF";

Blockly.Blocks.fade_led = {
  init: function() {
    this.appendDummyInput()
        .appendTitle(Blockly.MIXLY_LED_ON_BOARD1)//.appendField("fade_led")
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_boad.png",110,50));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_BT_fade_LED1).setAlign(Blockly.ALIGN_RIGHT)
        .setCheck(Number);
    this.setPreviousStatement(false, null);
    this.setNextStatement(false, null);
    this.setColour(Blockly.makeColour(controlcolor));
    this.setTooltip(Blockly.MIXLY_fadeLED_Tip);
  }
};
// BT board Icon
// Blockly.Blocks.UNO_Board = {
//   init: function() {
//     this.appendDummyInput()
//         // .appendTitle(Blockly.MIXLY_LED_ON_BOARD1)//.appendField("fade_led")
//         .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_UNO.png",390,260));
//     // this.appendValueInput("PIN", Number)
//     //     .appendTitle(Blockly.MIXLY_BT_fade_LED).setAlign(Blockly.ALIGN_RIGHT)
//     //     .setCheck(Number);
//     this.setPreviousStatement(false, null);
//     this.setNextStatement(false, null);
//     this.setColour(Blockly.makeColour("#2b2718"));
//     this.setTooltip(Blockly.MIXLY_fadeLED_Tip);
//   }
// };

Blockly.Blocks.my_led = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_BT_LED2)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_led11.png", 60, 36));
    this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN) .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
        .FieldDropdown([[Blockly.MIXLY_new_Off, "LOW"], [Blockly.MIXLY_new_On, "HIGH"]]), "STAT");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip(Blockly.MIXLY_BT_LED_Tip);
  }
};

Blockly.Blocks.Input_Value= {
 init: function() {
  this.setColour(Blockly.makeColour("#d6d6cb"));
  this.appendDummyInput("")
      .appendField(new Blockly.FieldDropdown(value), "NUM")
  this.setOutput(true,Number);
  //this.setTooltip(Blockly.MIXLY_TOOLTIP_INOUT_HIGHLOW);
}
};
//test1219   by nisiyang
Blockly.Blocks.my_trafficled = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendField("红绿灯模块")
        //.appendTitle(Blockly.MIXLY_BT_LED2)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_led11.png", 60, 36));
    this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN) .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
        .FieldDropdown([[Blockly.MIXLY_new_Off, "LOW"], [Blockly.MIXLY_new_On, "HIGH"]]), "STAT");
    this.appendValueInput("DELAY_TIME", Number)
        .setCheck(Number)
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField(Blockly.MIXLY_DELAY + '(' + Blockly.MIXLY_MILLIS + ')');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    //this.setTooltip(Blockly.MIXLY_BT_LED_Tip);
  }
}
Blockly.Blocks.my_trafficled1 = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendField("红绿灯模块")
        //.appendTitle(Blockly.MIXLY_BT_LED2)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_led11.png", 60, 36));
    this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN) .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
        .FieldDropdown([[Blockly.MIXLY_new_Off, "LOW"], [Blockly.MIXLY_new_On, "HIGH"]]), "STAT");
    this.appendValueInput("DELAY_TIME", Number)
        .setCheck(Number)
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField(Blockly.MIXLY_DELAY + '(' + Blockly.MIXLY_MILLIS + ')');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    //this.setTooltip(Blockly.MIXLY_BT_LED_Tip);
  }
}
Blockly.Blocks.my_trafficled2 = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendField("红绿灯模块")
        //.appendTitle(Blockly.MIXLY_BT_LED2)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_led11.png", 60, 36));
    this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN) .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
        .FieldDropdown([[Blockly.MIXLY_new_Off, "LOW"], [Blockly.MIXLY_new_On, "HIGH"]]), "STAT");
    this.appendValueInput("DELAY_TIME", Number)
        .setCheck(Number)
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField(Blockly.MIXLY_DELAY + '(' + Blockly.MIXLY_MILLIS + ')');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    //this.setTooltip(Blockly.MIXLY_BT_LED_Tip);
  }
}
//end test
Blockly.Blocks.my_LED_analog_write = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendValueInput("PIN", Number)
    .appendField(Blockly.MIXLY_BT_LED11)
    .setCheck(Number)
    .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_led.png", 60, 36)).appendTitle(Blockly.MIXLY_PIN);
    this.appendValueInput("NUM", Number)
    .appendField(Blockly.MIXLY_VALUe_From)
    .setCheck(Number);
    //this.setFieldValue("4","NUM");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip(Blockly.MIXLY_BT_LED_Tip2);
  }
};

// Blockly.Blocks.tone_notes1 = {
//     init:function() {
//     this.setColour(Blockly.makeColour(40));
//     this.appendDummyInput("")
//         .appendField(new Blockly.FieldDropdown(TONE_NOTES), 'STAT');
//     this.setOutput(true, Number);
//   }
// };

Blockly.Blocks.my_buzzer={
init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_BT_BUZZER1)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_buzzer.png", 57, 32));
    this.appendValueInput("PIN", Number)
        .appendField(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_FREQUENCY)
        .appendField(new Blockly.FieldDropdown(TONE_NOTES), 'STAT');
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip(Blockly.MIXLY_new_buzzer1);
  }
};

Blockly.Blocks.no_tone={
init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_NOTONE_PIN)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_buzzer.png", 41,19));
    this.appendDummyInput("")
          .appendField(Blockly.MIXLY_NOTONE_PIN2);  
    this.appendValueInput("PIN", Number)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setPreviousStatement(true);
    this.setNextStatement(true);
    this.setTooltip(Blockly.MIXLY_new_buzzer1);
  }
};

Blockly.Blocks.no_tone1={
init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_new_Clear)//translation from BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_speaker1.png", 41,19));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_NOTONE_PIN2);   
    this.appendValueInput("PIN", Number)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setPreviousStatement(true);
    this.setNextStatement(true);
    this.setTooltip("可控制扬声器停止播放声音");
  }
};

 Blockly.Blocks.my_speaker1={
  init:function(){
      this.setColour(Blockly.makeColour(displaycolor));
      this.appendDummyInput("")
          .appendField(Blockly.MIXLY_BT_SPEAKER)//translation from BT_robot
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_speaker1.png", 57, 32));       
      this.appendValueInput("PIN", Number)
          .appendField(Blockly.MIXLY_PIN)
          .setCheck(Number);
      this.appendValueInput('FREQUENCY',Number)
          .setCheck(Number)
          .appendField(Blockly.MIXLY_FREQUENCY);
      this.setInputsInline(true);
      this.setPreviousStatement(true);
      this.setNextStatement(true);
      this.setTooltip("可控制扬声器以固定频率播放声音,频率输入值范围0~5000");
    }
  };
  // Spea
  Blockly.Blocks.my_speaker2={
  init:function(){
      this.setColour(Blockly.makeColour(displaycolor));
      this.appendDummyInput("")
          .appendField(Blockly.MIXLY_BT_SPEAKER)//translation from BT_robot
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_speaker1.png", 57, 32));       
      this.appendValueInput("PIN", Number)
          .appendField(Blockly.MIXLY_PIN)
          .setCheck(Number);
      this.appendValueInput('FREQUENCY')
          .setCheck(Number)
          .appendField(Blockly.MIXLY_FREQUENCY);
      this.appendValueInput('DURATION')
          .setCheck(Number)
          .appendField(Blockly.MIXLY_DURATION);
      this.appendDummyInput("")
          .appendField("(ms)");
      this.setInputsInline(true);
      this.setPreviousStatement(true);
      this.setNextStatement(true);
      this.setTooltip("可控制扬声器以固定时间、频率播放声音，频率输入值范围0~5000");
    }
  };

Blockly.Blocks.my_speaker3={
init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_BT_SPEAKER)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_speaker1.png", 57, 32));
    this.appendValueInput("PIN", Number)
        .appendField(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_FREQUENCY)
        .appendField(new Blockly.FieldDropdown(TONE_NOTES), 'STAT');
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("可控制扬声器发出不同频率的声音");
  }
};

Blockly.Blocks.my_potentiometer = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_BT_POTENTIOMETER)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Knob11.png", 60, 36));
    this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setOutput(true, Number);
    this.setTooltip('模拟信号，传感器旋转角度为0-270°，有效参数范围在0-1023之间。');
  }
};

Blockly.Blocks.my_joystick = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_JOYSTICK_A)
        .appendTitle(new Blockly.FieldDropdown([["x", "x"], ["y", "y"]]), "STAT")
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_joystick.png", 60, 36));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setOutput(true, Number);
    this.setTooltip('模拟信号，利用前后左右拨动摇杆去进行方向上的调整，具有(X,Y)2轴模拟输出。');
  }
};

Blockly.Blocks.my_light = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_LIGHT1)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_light.png", 60, 36));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setOutput(true, Number);
    this.setTooltip(Blockly.MIXLY_new_light);
  }
};

// Blockly.Blocks.my_dht = {
//       init: function () {
//           var WHAT = [[Blockly.MIXLY_GETTEMPERATUE, 'temperature'], [Blockly.MIXLY_GETHUMIDITY, 'humidity']];
//           // var BT_DHT_IMG = [
//           //   [{'src': '../../media/yfrobot/BT_dht11.png', 'width': 50, 'height': 32, 'alt': 'DHT11'}, '11'], 
//           //   [{'src': '../../media/yfrobot/BT_dht22.png', 'width': 54, 'height': 32, 'alt': 'DHT22'}, '22']
//           // ];
//           this.setColour(Blockly.makeColour(controlcolor));
//           this.appendDummyInput("")
//               .appendField("T&H")
//               .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_temperature.png", 60, 36))
//               .appendField(Blockly.MIXLY_PIN)
//               .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN")
//               .appendField(" ")
//               .appendField(new Blockly.FieldDropdown(WHAT), "WHAT");
//           this.setOutput(true, Number);
//           this.setInputsInline(true);
//           var thisBlock = this;
//           this.setTooltip(function () {
//               var op = thisBlock.getFieldValue('WHAT');
//               var TOOLTIPS = {
//                   'temperature': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_TEM,
//                   'humidity': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_HUM
//               };
//               return TOOLTIPS[op];
//           });
//           this.setFieldValue("4","PIN");
//       }
//   };

Blockly.Blocks.my_dht = {
      init: function () {
          var WHAT = [[Blockly.MIXLY_GETTEMPERATUE, 'temperature'], [Blockly.MIXLY_GETHUMIDITY, 'humidity']];
          // var BT_DHT_IMG = [
          //   [{'src': '../../media/BT_Media/BT_temperature.png', 'width': 50, 'height': 32, 'alt': 'DHT11'}, '11'], 
          //   [{'src': '../../media/BT_Media/BT_temperature1.png', 'width': 54, 'height': 32, 'alt': 'DHT22'}, '22']
          // ];
          var BT_DHT_IMG = [["DHT11","11" ],["DHT22", "22"]];
          this.setColour(Blockly.makeColour(controlcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_Tnh)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_temperature1.png", 60, 36))
              .appendField(Blockly.MIXLY_DnH)
              .appendField(new Blockly.FieldDropdown(BT_DHT_IMG), 'TYPE')
              .appendField(Blockly.MIXLY_PIN)
              .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN")
              .appendField(" ")
              .appendField(new Blockly.FieldDropdown(WHAT), "WHAT");
          this.setOutput(true, Number);
          this.setInputsInline(true);
          // var thisBlock = this;
          // this.setTooltip(function () {
          //     var op = thisBlock.getFieldValue('WHAT');
          //     var TOOLTIPS = {
          //         'temperature': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_TEM,
          //         'humidity': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_HUM
          //     };
          //     return TOOLTIPS[op];
          // });
          this.setFieldValue("4","PIN");
          this.setTooltip(Blockly.MIXLY_TEMP);
      }
  };

Blockly.Blocks.my_flame = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_FLAME1)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_flame11.png", 60, 36));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setOutput(true, Number);
    this.setTooltip('可检测红外热源强度,距离（5~50cm),返回值范围0~1023');
  }
};

Blockly.Blocks.VoiceSensor = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_Record)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Record.png", 60, 36));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setInputsInline(true);
    this.setOutput(true, null);
    this.setTooltip(Blockly.MIXLY_new_VoiceSensor);
  }
};

Blockly.Blocks.metrix_LED_Init = {
    init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendField(Blockly.MIXLY_DISPLAY_MATRIX_INIT1);
    this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(Blockly.MIXLY_BT_BRIGHTNESS)
        .appendField(new Blockly.FieldDropdown(Brightness_level), "Brightness").appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 100,52));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName');
      //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 41, 32));
    this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SDA#");
    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SCL#"); 
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("连接V5 G SCL SDA 管脚,初始化点阵屏");
   }
};

Blockly.Blocks.Metrix_display={
    init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_DISPLAY_Charater).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 80, 30));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName').appendField(Blockly.MIXLY_DISPLAY_MATRIX_SHOW);
    this.appendValueInput("TEXT", String).setCheck([Number, String]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_4DIGITDISPLAY_DISPLAYSTRING1);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("可显示文本信息,输入值类型数字,字母,标点符号");
  }
};

var Icon_VAL=[ 
    [{'src': '../../media/BT_Media/IconMatrix/BT_Love.png',         'width': 32, 'height': 32, 'alt': 'Love'},        "love"], 
    [{'src': '../../media/BT_Media/IconMatrix/BT_Dash.png',         'width': 32, 'height': 32, 'alt': 'Dash'},        'triangle'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Down.png',         'width': 32, 'height': 32, 'alt': 'Down'},        'down'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Left.png',         'width': 32, 'height': 32, 'alt': 'Left'},        'left'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Up.png',           'width': 32, 'height': 32, 'alt': 'Up'},          'up'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Right.png',        'width': 32, 'height': 32, 'alt': 'Right'},       'right'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Error.png',        'width': 32, 'height': 32, 'alt': 'Error'},       'error'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Correct.png',      'width': 32, 'height': 32, 'alt': 'Correct'},     'correct'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Circle.png',       'width': 32, 'height': 32, 'alt': 'Circle'},      'circle'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Square.png',       'width': 32, 'height': 32, 'alt': 'Square'},      'squarez'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Smile.png',        'width': 32, 'height': 32, 'alt': 'Smile'},       'smile'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Happy.png',        'width': 32, 'height': 32, 'alt': 'Happy'},       'happy'],
    [{'src': '../../media/BT_Media/IconMatrix/BT_Sad.png',          'width': 32, 'height': 32, 'alt': 'Sad'},         'sad'],
];

Blockly.Blocks.Metrix_display_icon={
   init: function() {
    this.setColour(displaycolor);
    this.appendDummyInput()
        .appendField(Blockly.MIXLY_DISPLAY_Icon).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 80, 30));
    this.appendDummyInput()
        .appendField(Blockly.MIXLY_DISPLAY_Icon1)
        .appendField(new Blockly.FieldDropdown(Icon_VAL), 'String');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("可显示自带图形库的图形");
  }
};

Blockly.Blocks.Lattice_LED_clear={
  init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_Claer1)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png",41, 19));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName').appendField("点阵屏清屏");
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_Claer2)
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("清空点阵屏显示的文本");
  }
};

// Blockly.Blocks.Lattice_LED_clear1={
//   init:function(){
//     this.setColour(Blockly.makeColour(displaycolor));
//     this.appendDummyInput("")
//         .appendTitle(Blockly.MIXLY_BT_Claer3)
//         .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png",41, 19));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName').appendField("点阵屏清屏");
//     this.appendDummyInput("")
//         .appendTitle(Blockly.MIXLY_BT_Claer4)
//     this.setPreviousStatement(true, null);
//     this.setNextStatement(true, null);
//     this.setInputsInline(true);
//     this.setTooltip("清空点阵屏显示的图形");
//   }
// };

Blockly.Blocks.metrix_brightness = {
    init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("").appendField(Blockly.MIXLY_BT_BRIGHTNESS)
        .appendField(new Blockly.FieldDropdown(Brightness_level), "Brightness");
      //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 41, 32));
      //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 100, 130, { alt: "*", flipRtl: "FALSE" }))
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("调整屏幕亮度");
   }
};

Blockly.Blocks.my_relay = {
  init: function() {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_RELAY1)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_relay.png", 60, 35));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.appendDummyInput("")   
        .appendTitle(Blockly.MIXLY_STAT)
        .appendTitle(new Blockly.FieldDropdown([[Blockly.MIXLY_new_relayOpen, "HIGH"], [Blockly.MIXLY_new_relayClose, "LOW"]]), "STAT");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("可控制继电器导通或断开");
  }
};

Blockly.Blocks.my_pyroelectric_infrared = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_PYROELECTRIC_INFRARED)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_pyroelectric_infrared.png", 41, 32));
    this.appendValueInput("PIN", Number)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setOutput(true, null);
    this.setInputsInline(true);
    this.setTooltip('可检测是否有红外热源返回值0/1');
  }
};

Blockly.Blocks.my_button = {
  init: function() {
    this.setColour(Blockly.makeColour(controlcolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_BTN12)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_button.png", 60, 36));
    this.appendValueInput("PIN", null)
        .appendTitle(Blockly.MIXLY_PIN)
        .setCheck(Number);
    this.setOutput(true,);
    this.setInputsInline(true);
    this.setTooltip('可检测按压动作,有按下松开两种状态,返回值为0/1');
  }
};

Blockly.Blocks.mu_setup = {
  init: function() {
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput().appendField(new Blockly.FieldImage("../../media/BT_Media/BT_cam_mu.png",90, 67))
        .appendField(Blockly.LKL_VS2_SetupVS)
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ");
    this.appendStatementInput('SETUP_BLOCK');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
  }
};

// Blockly.Blocks.distancesensor = {
//   init: function() {
//     this.setColour(Blockly.makeColour(controlcolor));
//     this.appendDummyInput("").appendTitle(Blockly.MIXLY_BT_LED)// english /chinese translation base on BT_robot
//         .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Ultra.png", 60, 36));
//     this.appendValueInput("PIN", Number).appendTitle(Blockly.MIXLY_PIN) .setCheck(Number);
//     this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
//         .FieldDropdown([[Blockly.MIXLY_ON, "HIGH"], [Blockly.MIXLY_OFF, "LOW"]]), "STAT");
//     this.setPreviousStatement(true, null);
//     this.setNextStatement(true, null);
//   }
// };

Blockly.Blocks.distancesensor = {
    init: function () {
        this.setColour(Blockly.makeColour(controlcolor));
        this.appendDummyInput("")
            .appendField(Blockly.MIXLY_CHAOSHENGB).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_distance11.png", 50, 36))
        this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("trig");
        this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("echo"); 
        this.setOutput(true, Number);
        //this.setTooltip(Blockly.MIXLY_TOOLTIP_BLOCKGROUP_CHAOSHENGBO);
        this.setInputsInline(true); 
        //this.setPreviousStatement(true, null);
        //this.setNextStatement(true, null);
        this.setOutput(true,null);
        this.setInputsInline(true);
        this.setTooltip('可检测4~240cm之间距离,返回值范围4~240,误差±5%');
    }
};
 
  // IR Proximity switch
  Blockly.Blocks.infrared_tracking = {
    init: function() {
      this.setColour(Blockly.makeColour(controlcolor));
      this.appendDummyInput("")
          .appendField(Blockly.MIXLY_BT_IRP)
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_infrared_tracking.png", 96, 32));
      this.appendValueInput("PIN", Number)
          .appendField(Blockly.MIXLY_PIN)
          .setCheck(Number);
      this.setOutput(true, null);
      this.setInputsInline(true);
      this.setTooltip('可检测黑色或白色,返回值为0/1');
    }
  };

Blockly.Blocks.IR_Distance = {
    init: function() {
      this.setColour(Blockly.makeColour(controlcolor));
      this.appendDummyInput("")
          .appendField(Blockly.MIXLY_BT_IRFAR)
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_IR_Distance.png", 96, 32));
      this.appendValueInput("PIN", Number)
          .appendField(Blockly.MIXLY_PIN)
          .setCheck(Number);
      this.setOutput(true, null);
      this.setInputsInline(true);
      this.setTooltip('可检测是否有障碍物,返回值0/1');
    }
  };



//MPU6050
Blockly.Blocks.MPU6050imu = {
  init: function() {
    this.setColour(controlcolor);
    this.appendDummyInput("")
    .appendField(Blockly.MIXLY_gyro2).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_gyro11.png", 98, 36));
    this.appendDummyInput("")
    .setAlign(Blockly.ALIGN_RIGHT)
    .appendField(new Blockly.FieldDropdown([
      [Blockly.MIXLY_Gyro_X, "normAccel.XAxis"], 
      [Blockly.MIXLY_Gyro_Y, "normAccel.YAxis"], 
      [Blockly.MIXLY_Gyro_Z, "normAccel.ZAxis"],
      [Blockly.MIXLY_Accel_X,  "normGyro.XAxis"],
      [Blockly.MIXLY_Accel_Y,  "normGyro.YAxis"],
      [Blockly.MIXLY_Accel_Z,  "normGyro.ZAxis"],
      [Blockly.MIXLY_readTempC,"mpu.readTemperature()"]
      ]), "MPU6050_TYPE");
    this.setInputsInline(true);
    this.setOutput(true);
    this.setTooltip(Blockly.MIXLY_gyro22);
  }
};
// Blockly.makeColour(controlcolor)

//MPU6050
Blockly.Blocks.MPU6050_refres= {
   init: function() {
   this.setColour(controlcolor);
   this.appendDummyInput("").appendField(Blockly.MIXLY_gyro1).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_gyro11.png", 98, 36));
   this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SCL");
   this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SDA"); 
   this.setPreviousStatement(true);
   this.setNextStatement(true);
   this.setInputsInline(true);
   this.setTooltip(Blockly.MIXLY_gyro11);
 }
};

Blockly.Blocks['controls_if_if'] = {
  /**
   * Mutator block for if container.
   * @this Blockly.Block
  */
   init: function() {
    this.setColour(Blockly.Blocks.loops.HUE);
    this.appendDummyInput()
    .appendField(Blockly.Msg.CONTROLS_IF_IF_TITLE_IF);
    this.appendStatementInput('STACK');
    this.setTooltip(Blockly.Msg.CONTROLS_IF_IF_TOOLTIP);
    this.contextMenu = false;
  }
};


Blockly.Blocks.IRremote = {
    init: function () {
        this.setColour(ControAlgorithm);
        this.appendValueInput("PIN", Number)
        .appendField(new Blockly.FieldTextInput('IR_item'), 'VAR')
        .appendField(Blockly.MIXLY_new_irremote).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_IRremote.png", 109, 47))
        .setCheck(Number).appendField(Blockly.MIXLY_PIN);
        this.appendStatementInput('DO')
        .appendField(Blockly.MIXLY_IR_RECEIVE_YES);
        this.appendStatementInput('DO2')
        .appendField(Blockly.MIXLY_IR_RECEIVE_NO);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setInputsInline(true);
        this.setTooltip("可接收10M内红外信号");
    },
    getVars: function () {
        return [this.getFieldValue('VAR')];
    },
    renameVar: function (oldName, newName) {
        if (Blockly.Names.equals(oldName, this.getFieldValue('VAR'))) {
            this.setTitleValue(newName, 'VAR');
        }
    }
};

   var IR_VAL=[ 
    [{'src': '../../media/BT_Media/IRremote/BT_OK.png',             'width': 32, 'height': 32, 'alt': 'ir_play'},        '0xFFA857'], 
    [{'src': '../../media/BT_Media/IRremote/BT_ir_pow.png',         'width': 32, 'height': 32, 'alt': 'ir_pow'},         '0xFFA25D'],
    [{'src': '../../media/BT_Media/IRremote/BT_menu.png',           'width': 32, 'height': 32, 'alt': 'ir_menu'},        '0xFF629D'],
    [{'src': '../../media/BT_Media/IRremote/BT_speaker.png',        'width': 32, 'height': 32, 'alt': 'ir_test'},        '0xFFE21D'],
    [{'src': '../../media/BT_Media/IRremote/BT_left.png',           'width': 32, 'height': 32, 'alt': 'ir_'},            '0xFFE01F'],
    [{'src': '../../media/BT_Media/IRremote/BT_right.png',          'width': 32, 'height': 32, 'alt': 'ir_back'},        '0xFF906F'],
    [{'src': '../../media/BT_Media/IRremote/BT_up.png',             'width': 32, 'height': 32, 'alt': 'ir_rewind'},      '0xFF02FD'],
    [{'src': '../../media/BT_Media/IRremote/BT_down.png',           'width': 32, 'height': 32, 'alt': 'ir_fastForward'}, '0xFF9867'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_+.png',           'width': 32, 'height': 32, 'alt': 'ir_'},            '0xFF02FD'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_-.png',           'width': 32, 'height': 32, 'alt': 'ir_-'},           '0xFF9867'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_c.png',           'width': 32, 'height': 32, 'alt': 'ir_c'},           '0xFFB04F'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_0.png',           'width': 32, 'height': 32, 'alt': 'ir_0'},           '0xFF6897'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_1.png',           'width': 32, 'height': 32, 'alt': 'ir_1'},           '0xFF30CF'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_2.png',           'width': 32, 'height': 32, 'alt': 'ir_2'},           '0xFF18E7'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_3.png',           'width': 32, 'height': 32, 'alt': 'ir_3'},           '0xFF7A85'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_4.png',           'width': 32, 'height': 32, 'alt': 'ir_4'},           '0xFF10EF'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_5.png',           'width': 32, 'height': 32, 'alt': 'ir_5'},           '0xFF38C7'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_6.png',           'width': 32, 'height': 32, 'alt': 'ir_6'},           '0xFF5AA5'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_7.png',           'width': 32, 'height': 32, 'alt': 'ir_7'},           '0xFF42BD'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_8.png',           'width': 32, 'height': 32, 'alt': 'ir_8'},           '0xFF4AB5'],
    [{'src': '../../media/BT_Media/IRremote/BT_ir_9.png',           'width': 32, 'height': 32, 'alt': 'ir_9'},           '0xFF52AD'],
    ];

  Blockly.Blocks.IR_val = {
    init: function() {
      this.setColour(ControAlgorithm);
      this.appendDummyInput()
          .appendField(Blockly.MIXLY_IRvalue).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_IRremote.png", 95, 40)).appendField(Blockly.MIXLY_ir_equals)
          .appendField(new Blockly.FieldDropdown(IR_VAL), 'VAL');
      this.setOutput(true, Number);
      this.setTooltip("判断接收到的按键值是否等于设定的按键值,返回值为逻辑真/假");
    }
  };
  
  Blockly.Blocks.IRremote2 = {
    init: function() {
      this.setColour(ControAlgorithm);
      this.appendDummyInput()
          .appendField(Blockly.MIXLY_IRvalue).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_IRremote.png", 95, 40))
          .appendField(new Blockly.FieldDropdown(IR_VAL), 'VAL');
      this.setOutput(true, Number);
      this.setTooltip("返回按键所对应的值");
    }
  };
    
  Blockly.Blocks.rgb_LED = {
      init: function () {
          this.setColour(displaycolor);
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_RGB1)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RGB.png", 90, 30));
          this.appendValueInput("PIN", Number)
             .setCheck(Number)
             .setAlign(Blockly.ALIGN_RIGHT)
             .appendField(Blockly.MIXLY_PIN);
          this.appendValueInput("rgb_count")
              .setCheck(Number)
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_RGB_COUNT);
          this.appendValueInput("_LED_", Number)
              .setCheck(Number)
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_RGB_NUM);
          this.appendValueInput("BRIGHTNESS", Number)
              .setCheck(Number)
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_BT_BRIGHTNESS);
          this.appendDummyInput("")
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField("颜色")
              .appendField(new Blockly.FieldColour("#99FF99"), "RGB_LED_COLOR");
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setTooltip("可通过数字管脚调节灯的颜色与亮度,亮度输入值范围为0~255");
      }
  };



  //   Blockly.Blocks.rgb_display = {
  //     init: function () {
  //         this.setColour(displaycolor);
  //         this.appendDummyInput("")
  //             .appendField(Blockly.MIXLY_RGB)
  //             .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RGB.png", 85, 32));
  //         this.appendValueInput("_LED_", Number)
  //             .setCheck(Number)
  //             .setAlign(Blockly.ALIGN_RIGHT)
  //             .appendField(Blockly.MIXLY_RGB_NUM);
  //         this.appendDummyInput("")
  //             .setAlign(Blockly.ALIGN_RIGHT)
  //             .appendField(new Blockly.FieldColour("#99FF99"), "RGB_LED_COLOR");
  //         this.setInputsInline(true);
  //         this.setPreviousStatement(true, null);
  //         this.setNextStatement(true, null);
  //     }
  // };

  //  Blockly.Blocks.rgb_setbrightness = {
  //     init: function () {
  //         this.setColour(displaycolor);
  //         this.appendDummyInput("")
  //             .appendField(Blockly.MIXLY_RGB)
  //             .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RGB.png", 80, 30));
  //         this.appendValueInput("BRIGHTNESS", Number)
  //             .setCheck(Number)
  //             .setAlign(Blockly.ALIGN_RIGHT)
  //             .appendField(Blockly.MIXLY_BT_RGB_BRIGHTNESS);
  //         this.setInputsInline(true);
  //         this.setPreviousStatement(true, null);
  //         this.setNextStatement(true, null);
  //         this.setTooltip(Blockly.MIXLY_YFTIP_RGB_BRIGHTNESS);
  //     }
  // };

  Blockly.Blocks.Voice_Init = {
    init: function() {
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput("").appendField(Blockly.MIXLY_BT_InitVoice);
       // .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 41, 32));
        //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 100, 130, { alt: "*", flipRtl: "FALSE" }))    
    this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png", 60, 30));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName');
        //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 41, 32));
    this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX");
    this.setInputsInline(true); 
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("初始化语音识别模块连接双数字管脚");
   }
};

  Blockly.Blocks.Voice_in = {
  init: function() {
    this.setColour(aicolor);
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_BT_VoiceListen).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png",  60, 30));
    this.appendDummyInput("")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField(new Blockly.FieldDropdown(incomming_Voice), "Voice_in");
    this.setInputsInline(true);
    this.setOutput(true);
    this.setTooltip("判断接收到语音值是否与设定语音值一致,返回值为逻辑真/假。");
    //this.setOutput(true);
  }
};
 // Blockly.Blocks.BT_ir_val = {
 //    init: function() {
 //      this.setColour(yfrobotColor_ps2);
 //      this.appendDummyInput()
 //          .appendField(Blockly.MIXLY_BT_IR_VAL)
 //          .appendField(new Blockly.FieldDropdown(BT_IR_VAL), 'VAL');
 //      this.setOutput(true, Number);
 //      this.setTooltip(Blockly.MIXLY_IR_RECIEVE_TOOLTIP);
 //    }
 //  };

Blockly.Blocks.Voice_out = {
  init: function() {
    this.setColour(aicolor);
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_BT_VoiceReply).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png",60, 30));
    this.appendDummyInput("")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField(new Blockly.FieldDropdown(output_voice), "Voice_out");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("控制扬声器输出设定的语音值");
  }
};

Blockly.Blocks.Voice_clear={
  init:function(){
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput("")
        .appendTitle("clear_Voice")
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition.png", 40, 20));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName').appendField("点阵屏清屏");
      //.appendTitle("clear")
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("声音必须刷新才能继续");
  }
};

Blockly.Blocks.logic0 = {
  init: function() {
    this.appendValueInput("input",String).setCheck("null")//.//getInputTargetBlock('input').toString()
        .appendField(Blockly.MIXLY_BT_VoiceListen);
    // this.getInputTargetBlock('input').toString();
    this.appendValueInput("output",String).setCheck("null")
        .appendField(Blockly.MIXLY_BT_VoiceReply);
    this.setInputsInline(false);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.makeColour(aicolor));
    this.setTooltip('logic_input');
    this.setHelpUrl('https://www.arduino.cc/reference/en/');
  }
};

Blockly.Blocks['loopVoice'] = {
  init: function() {
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField("loopVoice")
       // .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ");
    this.appendStatementInput('SETUP_BLOCK');
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
  }
};

  Blockly.Blocks.TM1640_7segment = {
      init: function() {
          this.setColour(Blockly.makeColour(displaycolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_Init7seg)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_7segment.png", 90,32));
          this.appendDummyInput("").appendField(Blockly.MIXLY_BT_BRIGHTNESS)
              .appendField(new Blockly.FieldDropdown(Brightness_level), "Brightness");
          this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SDA#");
          this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SCL#"); 
            //.appendField(Blockly.MIXLY_PIN);
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setTooltip("连接管脚V5 G SDA SCL，并初始化四位数码管");
      }
  };

 Blockly.Blocks.TM1640_DisplayString = {
      init: function () {
          this.setColour(Blockly.makeColour(displaycolor));
          this.appendDummyInput()
              .appendField(Blockly.MIXLY_BT_4DIGITDISPLAY)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_7segment.png", 90, 23))
          this.appendValueInput("VALUE", String)
              .setCheck([String,Number])
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_BT_4DIGITDISPLAY_DISPLAYSTRING);
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setTooltip("可显示字母,数字,符号等,输入值类型为字符串string");
      }
  };

   Blockly.Blocks.TM1640_DisplayString1 = {
      init: function () {
          this.setColour(Blockly.makeColour(displaycolor));
          this.appendDummyInput()
              .appendField(Blockly.MIXLY_BT_4DIGITDISPLAY1)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_7segment.png", 90, 23))
          this.appendValueInput("VALUE", String)
              .setCheck([String,Number])
              .setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_BT_4DIGITDISPLAY_DISPLAYSTRING1);
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setTooltip("可以显示,数字.输入值类型是整数");
      }
  };

  Blockly.Blocks.Clear_TM1640={
  init:function(){
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendTitle(Blockly.MIXLY_BT_Clear7seg)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_7segment.png", 41, 19));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName').appendField("点阵屏清屏");
      //.appendTitle("clear")
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setTooltip("清空数码管显示内容");
  }
};


//////////////////////////MU Camera 

Blockly.Blocks.MuInit = {
  init: function() {
    //var dropdown_list = [["I2C","Wire"]].concat(profile.default.serial_select);
    var dropdown_list = [["IIC","Wire"],["UART","myCamSerial"]];
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_MU1).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_cam_mu.png", 87, 50))
        .appendTitle(Blockly.MU_ADDRESS)
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(' '+Blockly.LKL_VS2_SERIAL)
        .appendField(new Blockly.FieldDropdown(dropdown_list), "SERIAL");
    //this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(new Blockly.FieldTextInput('mySerial'), 'matrixName').appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png", 160, 100));
    this.appendValueInput("PIN1").setCheck(Number).appendField("(Mu01)").setAlign(Blockly.ALIGN_RIGHT).appendField("SDA#");
    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("(Mu01)").appendField("SCL#");
    this.appendValueInput("PIN3").setCheck(Number).appendField("(Mu00)").setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
    this.appendValueInput("PIN4").setCheck(Number).appendField("(Mu00)").setAlign(Blockly.ALIGN_RIGHT).appendField("RX"); 
    //.appendField(Blockly.MIXLY_PIN);
    //this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip(Blockly.MU_INIT_TIPS1);
}
  };

Blockly.Blocks['Vs2VisionBegin2'] = {
  init: function() {
    var lVs2VisionStatus = [[Blockly.LKL_VS2_ENABLE, "Begin"],[Blockly.LKL_VS2_DISABLE, "End"]];
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_cam_mu.png", 60, 30))
        .appendField(new Blockly.FieldDropdown(lVs2VisionStatus), "VisionStatus")
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_VISION_TYPE1)
        .appendField(new Blockly.FieldDropdown(VS_VISION_TYPE), "VisionType");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("启用或关闭Mu00或Mu01对应列表里的算法功能。");
  },
  // onchange: function(e) {
  //   var surround_parent = this.getSurroundParent();
  //   if (surround_parent && surround_parent.type == 'Vs2Setup') {
  //     this.setWarningText(null);
  //   } else {
  //     this.setWarningText(Blockly.LKL_VS2_WARNING_SETUP_ONLY);
  //   }
  // },
};


// Blockly.Blocks['SoftwareSerial'] = {
//   init: function() {
//     var BAUD = [["9600","9600"],["19200","19200"],["38400","38400"],["57600","57600"],
//     ["115200","115200"],["230400","230400"],["460800","460800"],["921600","921600"]];
//     this.setColour(Blockly.makeColour(aicolor));
//     this.appendDummyInput()
//         .appendField(Blockly.LKL_VS2_SET_UART_BAUD)
//         .appendField(new Blockly.FieldDropdown(BAUD), "BAUD");    
//     // this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX");
//     // this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
//     this.setInputsInline(true); 
//     this.setPreviousStatement(true, null);
//     this.setNextStatement(true, null);
//   },
// };

Blockly.Blocks['Vs2Detected2'] = {
  init: function() {
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_DETECTED1)
        .appendField(new Blockly.FieldDropdown(VS_VISION_TYPE), "VISION_TYPE").appendField(new Blockly.FieldImage("../../media/BT_Media/BT.png",  0, 27));
    this.setOutput(true, Number);
    this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
  }
};

Blockly.Blocks['Vs2DetectedRegionColor2'] = {
  init: function() {
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_RECOGNIZED)
        .appendField(Blockly.LKL_VS2_COORDINATE);
    this.appendValueInput('XValue')
        .setCheck(Number)
        .appendField('x=');
    this.appendValueInput('YValue')
        .setCheck(Number)
        .appendField('y=');
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_COLOR);
    this.setOutput(true, Number);
    this.setInputsInline(true);
    this.setTooltip("判断启用颜色识别算法后设定坐标区域是否检测到设定的颜色。");
  },
};

Blockly.Blocks['Vs2DetectedColorDetect2'] = {
  init: function() {
    var led_color = ['#000','#f00','#0f0','#ff0','#00f','#f0f','#0ff','#fff'];
    var color = new Blockly.FieldColour('#ff0000');
    color.setColours(led_color).setColumns(3);

    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_DETECTED)
        .appendField(color, 'DetectColor')
        .appendField(Blockly.LKL_VS2_COLOR_BLOCK).appendField(new Blockly.FieldImage("../../media/BT_Media/BT.png",  0, 27));
    this.setOutput(true, Number);
    this.setTooltip("判断启用色块检测算法后是否检测到到设定的颜色块,返回值为逻辑真/假。");
  }
};

Blockly.Blocks['Vs2GetColorLabel2'] = {
  init: function() {
    var led_color = ['#000','#f00','#0f0','#ff0','#00f','#f0f','#0ff','#fff'];
    var color = new Blockly.FieldColour('#ff0000');
    color.setColours(led_color).setColumns(3);

    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_GET_DETECTED_MESSAGE)
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_VISION_TYPE1)
        .appendField(Blockly.LKL_VS2_VISION_COLOR_RECOGNITION).appendField(new Blockly.FieldImage("../../media/BT_Media/BT.png",  0, 27));
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_COLOR+"=")
        .appendField(color, 'RCGColor');
    this.setOutput(true, Boolean);
    this.setInputsInline(true);
    this.setTooltip("判断启用颜色识别算法后识别到的颜色是否与设定颜色一致,返回值为逻辑真/假。");
  }
};

Blockly.Blocks['Vs2GetMessage2'] = {
  init: function() {
    this.DETECTED_MESSAGE = [[Blockly.LKL_VS2_STATE_VALUE_X,"kXValue"], 
                            [Blockly.LKL_VS2_STATE_VALUE_Y,"kYValue"],
                            [Blockly.LKL_VS2_STATE_VALUE_WIDTH,"kWidthValue"], 
                            [Blockly.LKL_VS2_STATE_VALUE_HEIGHT,"kHeightValue"],
                            [Blockly.LKL_VS2_STATE_VALUE_LABEL,"kLabel"]
                            ];
    this.ColorRCGMessage = [[Blockly.LKL_VS2_STATE_VALUE_R_CHANNEL,"kRValue"],
                            [Blockly.LKL_VS2_STATE_VALUE_G_CHANNEL,"kGValue"],
                            [Blockly.LKL_VS2_STATE_VALUE_B_CHANNEL,"kBValue"],
                            [Blockly.LKL_VS2_STATE_VALUE_LABEL,"kLabel"]
                            ];
    var vision_type = VS_VISION_TYPE.slice();

    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_GET_DETECTED_MESSAGE)
        .appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
        .appendField(Blockly.LKL_VS2_VISION_TYPE1)
        .appendField(new Blockly.FieldDropdown(vision_type), "VISION_TYPE").appendField(new Blockly.FieldImage("../../media/BT_Media/BT.png",  0, 27));
    this.vision_type_ = '';
    this.generateMessageType();
    this.setOutput(true, Number);
    this.setInputsInline(true);
    this.setTooltip("读取Mu00或Mu01对应算法检测到的物体的坐标或宽度等值。");
  },
  onchange: function(e) {
    var vision_type = this.getFieldValue("VISION_TYPE");
    if (this.vision_type_ != vision_type) {
      if (this.vision_type_ == "VISION_COLOR_RECOGNITION"
        || vision_type == "VISION_COLOR_RECOGNITION") {
        this.generateMessageType();
      } else {
        this.vision_type_ = vision_type;
      }
    }
  },
  generateMessageType: function() {
    var type_index = -1;
    if (this.vision_type_ != '') {
      var last_message_type = this.getFieldValue("DETECTED_MESSAGE");
      var color_message = [];
      var other_message = [];
      for (var i = 0; i < this.ColorRCGMessage.length; i++) {
        color_message.push(this.ColorRCGMessage[i][1]);
      }
      for (var i = 0; i < this.DETECTED_MESSAGE.length; i++) {
        other_message.push(this.DETECTED_MESSAGE[i][1]);
      }
      if (color_message.indexOf(last_message_type) != -1) {
        type_index = color_message.indexOf(last_message_type);
      } else if (other_message.indexOf(last_message_type) != -1) {
        type_index = other_message.indexOf(last_message_type);
      }
    }

    this.vision_type_ = this.getFieldValue("VISION_TYPE");
    this.removeInput("DetectedMessage");
    if (this.vision_type_ == "VISION_COLOR_RECOGNITION") {
      this.appendDummyInput("DetectedMessage")
          .appendField(new Blockly.FieldDropdown(this.ColorRCGMessage), "DETECTED_MESSAGE")
          .appendField(Blockly.LKL_VS2_VALUE);
      if (type_index != -1) {
        if (type_index == this.DETECTED_MESSAGE.length-1) {
          this.setFieldValue(this.ColorRCGMessage[this.ColorRCGMessage.length-1][1], "DETECTED_MESSAGE");
        } else {
          this.setFieldValue(this.ColorRCGMessage[type_index][1], "DETECTED_MESSAGE");
        }
      }
    } else {
      this.appendDummyInput("DetectedMessage")
          .appendField(new Blockly.FieldDropdown(this.DETECTED_MESSAGE), "DETECTED_MESSAGE")
          .appendField(Blockly.LKL_VS2_VALUE);
      if (type_index != -1) {
        if (type_index == this.ColorRCGMessage.length-1) {
          this.setFieldValue(this.DETECTED_MESSAGE[this.DETECTED_MESSAGE.length-1][1], "DETECTED_MESSAGE");
        } else {
          this.setFieldValue(this.DETECTED_MESSAGE[type_index][1], "DETECTED_MESSAGE");
        }
      }
    }
  },
};

Blockly.Blocks['Vs2GetCardType2'] = {
  init: function() {
    this.traffic_card_type_ = [["⬆ "+Blockly.LKL_VS2_CARD_STRAIGHT, "MU_TRAFFIC_CARD_FORWARD"],
                              ["⬅ "+Blockly.LKL_VS2_CARD_TURN_LEFT, "MU_TRAFFIC_CARD_LEFT"],
                              ["➡ "+Blockly.LKL_VS2_CARD_TURN_RIGHT, "MU_TRAFFIC_CARD_RIGHT"],
                              ["🔙 "+Blockly.LKL_VS2_CARD_TURN_AROUND, "MU_TRAFFIC_CARD_TURN_AROUND"],
                              ["🅿 "+Blockly.LKL_VS2_CARD_STOP, "MU_TRAFFIC_CARD_PARK"]
                              ];
    this.number_card_type_ = [["1", "1"],["2", "2"],["3", "3"],["4", "4"],["5", "5"],
                            ["6", "6"],["7", "7"],["8", "8"],["9", "9"],["0", "0"]
                            ];
    this.shape_card_type_ = [["✔ "+Blockly.LKL_VS2_CARD_TICK, "MU_SHAPE_CARD_TICK"],
                            ["✖ "+Blockly.LKL_VS2_CARD_CROSS, "MU_SHAPE_CARD_CROSS"],
                            ["⭕ "+Blockly.LKL_VS2_CARD_CIRCLE, "MU_SHAPE_CARD_CIRCLE"],
                            ["◻ "+Blockly.LKL_VS2_CARD_SQUARE, "MU_SHAPE_CARD_SQUARE"],
                            ["🛆 "+Blockly.LKL_VS2_CARD_TRIANGLE, "MU_SHAPE_CARD_TRIANGLE"],
                            ];
    this.card_class_dic_ = {'VISION_SHAPE_CARD_DETECT':this.shape_card_type_,
                            'VISION_TRAFFIC_CARD_DETECT':this.traffic_card_type_,
                            'VISION_NUM_CARD_DETECT':this.number_card_type_
                            };
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(Blockly.LKL_VS2_GET_DETECTED_MESSAGE)
        .appendField(new Blockly.FieldDropdown(lVsMu), "MuObj")
        .appendField(Blockly.LKL_VS2_VISION_TYPE1)
        .appendField(new Blockly.FieldDropdown(lVisionCardType), "VisionCardType")
        .appendField(" "+Blockly.LKL_VS2_CARD_TYPE+"=").appendField(new Blockly.FieldImage("../../media/BT_Media/BT.png",  0, 27));
    this.vision_type_ = this.getFieldValue("VisionCardType");
    this.appendDummyInput("CARD_TYPE")
        .appendField(new Blockly.FieldDropdown(this.card_class_dic_[this.vision_type_]), "CardType");
    this.setInputsInline(true);
    this.setOutput(true, Boolean);
    this.setTooltip("判断识别到的卡片形状是否与设定形状一致,返回值为逻辑真/假。");
  },
  onchange: function(e) {
    var vision_type = this.getFieldValue("VisionCardType");
    if (this.vision_type_ != vision_type) {
      this.vision_type_ = vision_type;
      var last_card_type = this.getFieldValue("CardType");
      var traffic_card_type = [];
      var number_card_type = [];
      var shape_card_type = [];
      var type_index = -1;
      for (var i = 0; i < this.traffic_card_type_.length; i++) {
        traffic_card_type.push(this.traffic_card_type_[i][1]);
      }
      for (var i = 0; i < this.number_card_type_.length; i++) {
        number_card_type.push(this.number_card_type_[i][1]);
      }
      for (var i = 0; i < this.shape_card_type_.length; i++) {
        shape_card_type.push(this.shape_card_type_[i][1]);
      }
      if (traffic_card_type.indexOf(last_card_type) != -1) {
        type_index = traffic_card_type.indexOf(last_card_type);
      } else if (number_card_type.indexOf(last_card_type) != -1) {
        type_index = number_card_type.indexOf(last_card_type);
      } else if (shape_card_type.indexOf(last_card_type) != -1) {
        type_index = shape_card_type.indexOf(last_card_type);
      }
      this.removeInput("CARD_TYPE");
      this.appendDummyInput("CARD_TYPE")
          .appendField(new Blockly.FieldDropdown(this.card_class_dic_[this.vision_type_]), "CardType");
      this.setFieldValue(this.card_class_dic_[this.vision_type_][type_index][1], "CardType");
    }
  },
};

Blockly.Blocks.iot_config = {
    init: function() {
    // var dropdown_list = [["I2C","Wire"]].concat(profile.default.serial_select);
    this.setColour(Blockly.makeColour(IOTcolor));
    // this.appendDummyInput()    
        // .appendField(' '+Blockly.LKL_VS2_SERIAL)
        // .appendField(new Blockly.FieldDropdown(dropdown_list), "SERIAL");
    this.appendDummyInput("").appendField(Blockly.MIXLY_BT_iot_Config).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 90, 60));
    //this.appendDummyInput().setAlign(Blockly.ALIGN_LEFT).appendField("WuG").appendField(new Blockly
    //.FieldTextInput('http://47.92.196.101:8088/'), 'matrixName');   
    //.appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
    //this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX");
    //this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
    //this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(new Blockly.FieldTextInput('mySerial'), 'matrixName').appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png", 160, 100));
    this.appendValueInput("WiFi_ID", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_WifiID);
    this.appendValueInput("wifi_pass", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_WiFiPass);
    this.appendValueInput("wifi_key", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_ProjectKey);
    //this.appendValueInput("auth_key", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField("Server"); 
    //.appendField(Blockly.MIXLY_PIN);
    //this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("连接4pin双数字口,初始化WIFI模块,右键模块选择帮助,进入云平台");
    this.setHelpUrl('http://iot.bettertree.cn/');
}};

 Blockly.Blocks.iot_receive_Display = {
      init: function () {
          var Payload = [[Blockly.MIXLY_BT_iot_Topic, 'Topic'],[Blockly.MIXLY_BT_iot_Buffer,'Buffer' ]];
          this.setColour(Blockly.makeColour(displaycolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_DisplayFromNET)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png",80, 30)); 
          this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_Topic);
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setInputsInline(true);
          this.setTooltip(Blockly.MIXLY_new_IotRX);
          this.setHelpUrl('http://iot.bettertree.cn/');
}};

///iot 2 START
Blockly.Blocks.iot_config = {
    init: function() {
    // var dropdown_list = [["I2C","Wire"]].concat(profile.default.serial_select);
    this.setColour(Blockly.makeColour(IOTcolor));
    // this.appendDummyInput()    
        // .appendField(' '+Blockly.LKL_VS2_SERIAL)
        // .appendField(new Blockly.FieldDropdown(dropdown_list), "SERIAL");
    this.appendDummyInput("").appendField(Blockly.MIXLY_BT_iot_Config).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 90, 60));
    //this.appendDummyInput().setAlign(Blockly.ALIGN_LEFT).appendField("WuG").appendField(new Blockly
    //.FieldTextInput('http://47.92.196.101:8088/'), 'matrixName');   
    //.appendField(new Blockly.FieldDropdown(lVsMu), "MU_OBJ")
    //this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX");
    //this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
    //this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(new Blockly.FieldTextInput('mySerial'), 'matrixName').appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png", 160, 100));
    this.appendValueInput("WiFi_ID", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_WifiID);
    this.appendValueInput("wifi_pass", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_WiFiPass);
    this.appendValueInput("wifi_key", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_ProjectKey);
    //this.appendValueInput("auth_key", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField("Server"); 
    //.appendField(Blockly.MIXLY_PIN);
    //this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip("连接4pin双数字口,初始化WIFI模块,右键模块选择帮助,进入云平台");
    this.setHelpUrl('http://iot.bettertree.cn/');
}
  };

Blockly.Blocks.iot_Serial = {
      init: function() {
          this.setColour(Blockly.makeColour(IOTcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_Serial)
           // .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_cam_mu.png", 60, 27));
          this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
          this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX"); 
            //.appendField(Blockly.MIXLY_PIN);
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setTooltip("虚拟串口V G RX TX,与WuG平台配合使用，+10dB天线增益，无障碍>50米通信距离");
          this.setHelpUrl('http://iot.bettertree.cn/');
      }
  };
  Blockly.Blocks.Iot_Init_Receive= {
      init: function() {
          this.setColour(Blockly.makeColour(IOTcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_Check)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 40, 30));
          // this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
          // this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX"); 
            //.appendField(Blockly.MIXLY_PIN);
          this.setOutput(true);
          this.setInputsInline(true);
          this.setTooltip(Blockly.MIXLY_BT_iot_Check_Tip);
          this.setHelpUrl('http://iot.bettertree.cn/');
      }
  };


Blockly.Blocks.iot_send = {
  init: function() {
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_BT_iot_send)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 60, 36));
    this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_Topic);
    this.appendValueInput("input1").setCheck(null)//.//getInputTargetBlock('input').toString()
        .appendField(Blockly.MIXLY_BT_iot_Read_Sensor);
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.makeColour(IOTcolor));
    this.setTooltip(Blockly.MIXLY_BT_iot_inforIoT);
    this.setHelpUrl('http://iot.bettertree.cn/');
  }
};



Blockly.Blocks.iot_receiveTopic = {
      init: function () {

          var Payload = [[Blockly.MIXLY_BT_iot_Buffer,'Buffer' ],[Blockly.MIXLY_BT_iot_Topic, 'Topic']];
          var Data_Source = [["Web",'Web' ],["Arduino", 'Arduino']];
          this.setColour(Blockly.makeColour(IOTcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_Sub)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 58, 20));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_Topicsouce)
              .appendField(new Blockly.FieldDropdown(Data_Source), 'Data_Source')  
          this.appendDummyInput("")
          this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_Topic);
              // .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN")
              // .appendField(" ")
              // .appendField(new Blockly.FieldDropdown(WHAT), "WHAT");
          this.setInputsInline(true);
          this.setPreviousStatement(true, null);
          this.setNextStatement(true, null);
          this.setInputsInline(true);
          this.setTooltip(Blockly.MIXLY_BT_iot_ReceiveVALTIP1);
          this.setHelpUrl('http://iot.bettertree.cn/');
      //         // var op = thisBlock.getFieldValue('WHAT');
      //         var TOOLTIPS = {
      //             'temperature': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_TEM,
      //             'humidity': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_HUM
      //         };
      //         return TOOLTIPS[op];
      //     });
      //     // this.setFieldValue("4","PIN");
     }
  };
  

//receive topic 
Blockly.Blocks.Receive_Topic = {
      init: function () {
          var Payload = [[Blockly.MIXLY_BT_iot_Buffer,'Buffer' ],[Blockly.MIXLY_BT_iot_Topic, 'Topic']];
          //var Data_Source = [["Web",'Web' ],["Arduino", 'Arduino']];
          this.setColour(Blockly.makeColour(IOTcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_ReceiveCompare)//receivetopic
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 58, 20));
          //this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_Topic);
          this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT)
              .appendField(Blockly.MIXLY_BT_iot_Topic).appendField("=");
              // .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN")
              // .appendField(" ")
              // .appendField(new Blockly.FieldDropdown(WHAT), "WHAT");
          this.setOutput(true);
          this.setInputsInline(true);
          this.setTooltip(Blockly.MIXLY_BT_iot_Check_Tip1);
          this.setHelpUrl('http://iot.bettertree.cn/');
      //         // var op = thisBlock.getFieldValue('WHAT');
      //         var TOOLTIPS = {
      //             'temperature': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_TEM,
      //             'humidity': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_HUM
      //         };
      //         return TOOLTIPS[op];
      //     });
      //     // this.setFieldValue("4","PIN");
     }
  };
//receive Value 
  Blockly.Blocks.Receive_Value = {
      init: function () {
          var Payload = [[Blockly.MIXLY_BT_iot_Buffer,'Buffer' ],[Blockly.MIXLY_BT_iot_Topic, 'Topic']];
          //var Data_Source = [["Web",'Web' ],["Arduino", 'Arduino']];
          this.setColour(Blockly.makeColour(IOTcolor));
          this.appendDummyInput("")
              .appendField(Blockly.MIXLY_BT_iot_ReceiveVAL)
              .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_WIFI.png", 40, 30));
          //this.appendValueInput("Input_topic", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_BT_iot_Topic);
          // this.appendDummyInput("")
          //     .appendField(Blockly.MIXLY_Payload)
          //     .appendField(new Blockly.FieldDropdown(Payload), 'Payload')
              // .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN")
              // .appendField(" ")
              // .appendField(new Blockly.FieldDropdown(WHAT), "WHAT");
          this.setOutput(true);
          this.setInputsInline(true);
          this.setTooltip(Blockly.MIXLY_BT_iot_ReceiveVALTIP);
          this.setHelpUrl('http://iot.bettertree.cn/');
      //         // var op = thisBlock.getFieldValue('WHAT');
      //         var TOOLTIPS = {
      //             'temperature': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_TEM,
      //             'humidity': Blockly.MIXLY_TOOLTIP_BLOCKGROUP_GET_HUM
      //         };
      //         return TOOLTIPS[op];
      //     });
      //     // this.setFieldValue("4","PIN");
     }
  };

///END 2

Blockly.Blocks.Record = {
  init: function() {
    this.setColour(Blockly.makeColour(ControAlgorithm));
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_RnP)// english /chinese translation base on BT_robot
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_R&P.png", 60, 36));
    this.appendValueInput("PIN1", Number).appendTitle(Blockly.MIXLY_R_PIN) .setCheck(Number);
    this.appendValueInput("PIN2", Number).appendTitle(Blockly.MIXLY_P_PIN) .setCheck(Number);
    this.appendDummyInput("").appendTitle(Blockly.MIXLY_STAT).appendTitle(new Blockly
        .FieldDropdown([[Blockly.MIXLY_BT_iot_P, "1"], [Blockly.MIXLY_BT_iot_R, "2"]]), "STATE");
    this.appendValueInput('DURATION')
        .setCheck(Number)
        .appendField(Blockly.MIXLY_DURATION);
    this.appendDummyInput("")
        .appendField("(ms)");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setTooltip(Blockly.MIXLY_infor);
    this.setTooltip("连接4Pin双数字管脚,集录音与播放功能为一体,支持10s内音频录放功能");
}};

Blockly.Blocks.Pulse = {
    init: function () {
       var BT_DHT_IMG = [[Blockly.MIXLY_IRvalue,"3" ],[Blockly.MIXLY_BPM, "1"],[Blockly.MIXLY_AvgBPM, "2"]];

        this.setColour(Blockly.makeColour(controlcolor));
        this.appendDummyInput("")
            .appendField(Blockly.MIXLY_pulse).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Pulse.png", 50, 36))
            .appendField(Blockly.MIXLY_Get)
            .appendField(new Blockly.FieldDropdown(BT_DHT_IMG), 'ValIn')
        this.setOutput(true, Number);
        //this.setTooltip(Blockly.MIXLY_TOOLTIP_BLOCKGROUP_CHAOSHENGBO);
        this.setInputsInline(true); 
        //this.setPreviousStatement(true, null);
        //this.setNextStatement(true, null);
        this.setOutput(true,null);
        this.setInputsInline(true);
        this.setTooltip(Blockly.MIXLY_Pulse_tip2);
}};

 Blockly.Blocks.Pulse_Init = {
 init: function() {
    this.appendDummyInput()
        .appendTitle(Blockly.MIXLY_PulseInit)//.appendField("fade_led")
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Pulse.png",60,36));
    this.appendDummyInput()
        .appendTitle(Blockly.MIXLY_PulseInit2);
    this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SCL");
    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SDA"); 
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setInputsInline(true);
    this.setColour(Blockly.makeColour(controlcolor));
    this.setTooltip(Blockly.MIXLY_Pulse_tip1);
}};

Blockly.Blocks.RFID_Init = {
    init: function () {
        this.setColour(ControAlgorithm);
        this.appendDummyInput("")
            .appendField(Blockly.MIXLY_RFID_Init).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RFidd.png", 60, 36));
      //this.appendDummyInput("")
      //    .appendField(Blockly.MIXLY_RFID_Init2);
      //this.appendValueInput("Legnth").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField(Blockly.MIXLY_ID_Legnth);
        this.appendDummyInput("")
            .appendField("  ");
        this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("RX");
        this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
      //this.appendStatementInput('DO')
      //    .appendField(Blockly.MIXLY_RFID_has);
      //this.appendStatementInput('DO2')
      //    .appendField(Blockly.MIXLY_RFID_else);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setInputsInline(true);
        this.setTooltip(Blockly.MIXLY_new_CommTip4);
    },
    getVars: function () {
        return [this.getFieldValue('VAR')];
    },
    renameVar: function (oldName, newName) {
        if (Blockly.Names.equals(oldName, this.getFieldValue('VAR'))) {
            this.setTitleValue(newName, 'VAR');
        }}
    };
var RFID_Val = [[Blockly.MIXLY_RFID_key,"Name" ],[Blockly.MIXLY_RFID_value, "Value"]];

Blockly.Blocks.RFID_Write= {
   init: function() {
   this.setColour(Blockly.makeColour(ControAlgorithm));
   this.appendDummyInput("")
       .appendField(Blockly.MIXLY_RFID_write2).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RFidd.png", 60, 36));
 //this.appendDummyInput("")
  //   .appendField(Blockly.MIXLY_RFID_write2);
// this.appendDummyInput("")
//     .setAlign(Blockly.ALIGN_RIGHT)
//     .appendField(new Blockly.FieldDropdown(RFID_Val), "RFID_Val");
   this.appendValueInput("RFID_ID", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField("ID");
   this.setPreviousStatement(true);
   this.setNextStatement(true);
   this.setInputsInline(true);
   this.setTooltip(Blockly.MIXLY_new_CommTip5);
 }
};

Blockly.Blocks.RFID_Read = {
  init: function() {
    this.setColour(Blockly.makeColour(ControAlgorithm));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_RFID_read2).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RFidd.png", 60, 36));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_RFID_Data);
 // this.appendDummyInput("")
 //     .setAlign(Blockly.ALIGN_RIGHT)
 //     .appendField(new Blockly.FieldDropdown(RFID_Val), "RFID_Val");
    this.setInputsInline(true);
    this.setOutput(true);
    this.setTooltip(Blockly.MIXLY_new_CommTip6);
  }
};

Blockly.Blocks.RFID_HasCard = {
  init: function() {
    this.setColour(Blockly.makeColour(ControAlgorithm));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_RFID_readval2)
        .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RFidd.png", 60, 36));  
//  this.appendDummyInput("")
//      .setAlign(Blockly.ALIGN_RIGHT)
//      .appendField(new Blockly.FieldDropdown(RFID_Val), "RFID_Val");
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_ir_equals); 
    this.appendValueInput("RFID_ID", String).setCheck([String,Number]).setAlign(Blockly.ALIGN_RIGHT).appendField("ID");
    this.setInputsInline(true);
    this.setOutput(true)
    this.setTooltip(Blockly.MIXLY_new_CommTip7);
  }
};

Blockly.Blocks.RFID_Available = {
    init: function () {
        this.setColour(ControAlgorithm);
        this.appendDummyInput("")
            .appendField(Blockly.MIXLY_new_CommCheck)
            .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_RFidd.png", 50, 27)); 
        this.appendStatementInput('DO')
            .appendField(Blockly.MIXLY_new_CommHasCard);
        this.appendStatementInput('DO2')
            .appendField(Blockly.MIXLY_new_CommNoCard);
        this.setPreviousStatement(true);
        this.setNextStatement(true);
        this.setInputsInline(true);
        this.setTooltip(Blockly.MIXLY_new_CommCheckTips);
    },
    getVars: function () {
        return [this.getFieldValue('VAR')];
    },
    renameVar: function (oldName, newName) {
        if (Blockly.Names.equals(oldName, this.getFieldValue('VAR'))) {
            this.setTitleValue(newName, 'VAR');
        }
    }
};

var PortName = [["A(D4~D3)","A" ],["B(D2~D5)", "B"],["C(D8~D6)", "C"],["D(D7~D9)", "D"]];
var Direction = [[Blockly.MIXLY_new_motor1,"1" ],[Blockly.MIXLY_new_motoro, "0"]];

//Blockly.Blocks.metrix_LED_Init = {
//    init: function() {
//    this.setColour(Blockly.makeColour(displaycolor));
//    this.appendDummyInput("").appendField(Blockly.MIXLY_DISPLAY_MATRIX_INIT1);
//    this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(Blockly.MIXLY_BT_BRIGHTNESS)
//        .appendField(new Blockly.FieldDropdown(Brightness_level), "Brightness").appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 100,52));//.appendField(new Blockly.FieldTextInput('myMatrix'), 'matrixName');
//      //.appendField(new Blockly.FieldImage("../../media/BT_Media/BT_8x8led.png", 41, 32));
//    this.appendValueInput("PIN1").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SDA#");
//    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("SCL#"); 
//    this.setPreviousStatement(true, null);
//    this.setNextStatement(true, null);
//    this.setTooltip("连接V5 G SCL SDA 管脚,初始化点阵屏");
//   }
//};

Blockly.Blocks.Motor_Drive = {
  init: function () {
    this.setColour(Blockly.makeColour(displaycolor));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_new_motorName).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Motor3.png", 60, 36));
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_new_motorPort)
        .appendField(new Blockly.FieldDropdown(PortName), 'Portname')
    this.appendDummyInput("")
        .appendField(Blockly.MIXLY_new_motorDirection)
        .appendField(new Blockly.FieldDropdown(Direction), 'Direction')
    this.appendValueInput('speed')
        .setCheck(Number)
        .appendField(Blockly.MIXLY_VALUe_From);
    this.setInputsInline(true);
    this.setPreviousStatement(true);
    this.setNextStatement(true);
    this.setTooltip("可控制对应端口的电机正传或反转，速度输入值范围0~255");
  }};

  Blockly.Blocks.Moisture = {
    init: function() {
      this.setColour(Blockly.makeColour(controlcolor));
      this.appendDummyInput("")
          .appendField(Blockly.MIXLY_Soil_Sensor)
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Soil11.png", 60, 36));
      this.appendValueInput("PIN", Number)
          .appendField(Blockly.MIXLY_PIN)
          .setCheck(Number);
      this.setInputsInline(true);
      this.setOutput(true, Number);
      this.setTooltip(Blockly.MIXLY_new_Moisture);
    }
  };

  Blockly.Blocks.My_Servo = {
  init: function () {
     this.setColour(Blockly.makeColour(displaycolor));
     this.appendDummyInput("")
         .appendField(Blockly.MIXLY_SERVO12).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_Servor3.png", 60, 36))
         .appendField(Blockly.MIXLY_PIN)
         .appendField(new Blockly.FieldDropdown(profile.default.digital), "PIN");
     this.appendValueInput("DEGREE", Number)
         .setCheck(Number)
         .setAlign(Blockly.ALIGN_RIGHT)
         .appendField(Blockly.MIXLY_DEGREE_0_180);
     this.appendValueInput("DELAY_TIME", Number)
         .setCheck(Number)
         .setAlign(Blockly.ALIGN_RIGHT)
         .appendField(Blockly.MIXLY_DELAY + '(' + Blockly.MIXLY_MILLIS + ')');
     this.setInputsInline(true);
     this.setPreviousStatement(true, null);
     this.setNextStatement(true, null);
     this.setTooltip(Blockly.MIXLY_TOOLTIP_BLOCKGROUP_SERVO_MOVE);
     this.setFieldValue("2", "PIN");
  }};

// Blockly.Blocks.My_PID_Init = {
//   init: function () {
//     this.setColour(Blockly.makeColour(ControAlgorithm));
//     this.appendDummyInput("")
//         .appendField("PID_Init,");
//     this.appendValueInput("ValueP")
//         .appendField("Kp");
//     this.appendValueInput("ValueI")
//         .appendField("Ki");
//     this.appendValueInput("ValueD")
//         .appendField("Kd");
//     this.appendValueInput("Desired_Value", Number)
//         .appendField("Desired_Value");
//  // this.appendDummyInput("")
//  //     .setAlign(Blockly.ALIGN_RIGHT)
//  //     .appendField("颜色")
//  //     .appendField(new Blockly.FieldColour("#99FF99"), "RGB_LED_COLOR");
//     this.setInputsInline(true);
//     this.setPreviousStatement(true, null);
//     this.setNextStatement(true, null);
//     this.setTooltip("PID Computation algorithm ");
//       }
//   };

//siyang 
Blockly.Blocks.robotvoice_pins_voice = {
  init: function() {
   this.setColour(displaycolor);
   this.appendDummyInput("")
       .appendField(new Blockly.FieldDropdown(VOICE_PIN), 'VOICE');
   this.setOutput(true, Number);
 }
};

Blockly.Blocks.robotvoice_voice = {
 init: function() {
   this.setColour(displaycolor);
 this.appendDummyInput("")
     .appendField("语音播放模块A")
     .appendField(new Blockly.FieldImage("../../media/BT_Media/VOICE.png", 63,40));
 this.appendValueInput("PIN", Number).appendField(Blockly.MIXLY_PIN).setCheck(Number);
 this.appendValueInput("BUSY", Number).appendField("BUSY引脚").setCheck(Number);
 this.appendValueInput("VOICE").appendField("播放").setCheck(Number);
 this.appendValueInput("WAIT").setCheck(Number).appendField("等待（ms）");
   this.setPreviousStatement(true, null);
   this.setNextStatement(true, null);
 this.setInputsInline(true);
 
 }
};


Blockly.Blocks.BT_robotvoice_pins_voice = {
  init: function() {
   this.setColour(displaycolor);
   this.appendDummyInput("")
       .appendField(new Blockly.FieldDropdown(BT_VOICE_PIN), 'BTVOICE');
   this.setOutput(true, Number);
 }
};

Blockly.Blocks.BT_robotvoice_voice = {
 init: function() {
   this.setColour(displaycolor);
 this.appendDummyInput("")
     .appendField("语音播放模块B")
     .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VOICE.png", 63,40));
 this.appendValueInput("PIN", Number).appendField(Blockly.MIXLY_PIN).setCheck(Number);
 this.appendValueInput("BUSY", Number).appendField("BUSY引脚").setCheck(Number);
 this.appendValueInput("VOICE").appendField("播放").setCheck(Number);
 this.appendValueInput("WAIT").setCheck(Number).appendField("等待（ms）");
   this.setPreviousStatement(true, null);
   this.setNextStatement(true, null);
 this.setInputsInline(true);
 //this.setOutput(true, Number);//siyang
 }
};

//2021/12/28
Blockly.Blocks.sentryVision_Init = {
  init: function() {
    //var dropdown_list = [["I2C","Wire"]].concat(profile.default.serial_select);
    var dropdown_list = [["IIC","Wire"],["UART","myCamSerial"]];
    this.setColour(Blockly.makeColour(aicolor));
    this.appendDummyInput()
        .appendField(Blockly.LKL_Sen2_VISION_INIT).appendField(new Blockly.FieldImage("../../media/BT_Media/BT_senpry.png", 87, 50))
        .appendTitle(Blockly.MU_ADDRESS)
        .appendField(new Blockly.FieldDropdown(Sentry), "Sen_OBJ")
        .appendField(' '+Blockly.LKL_VS2_SERIAL)
        .appendField(new Blockly.FieldDropdown(dropdown_list), "SERIAL");
    //this.appendDummyInput("").setAlign(Blockly.ALIGN_LEFT).appendField(new Blockly.FieldTextInput('mySerial'), 'matrixName').appendField(new Blockly.FieldImage("../../media/BT_Media/BT_VoiceRecognition1.png", 160, 100));
    this.appendValueInput("PIN1").setCheck(Number).appendField("(Sen01)").setAlign(Blockly.ALIGN_RIGHT).appendField("SDA#");
    this.appendValueInput("PIN2").setCheck(Number).setAlign(Blockly.ALIGN_RIGHT).appendField("(Sen01)").appendField("SCL#");
    this.appendValueInput("PIN3").setCheck(Number).appendField("(Sen00)").setAlign(Blockly.ALIGN_RIGHT).appendField("TX");
    this.appendValueInput("PIN4").setCheck(Number).appendField("(Sen00)").setAlign(Blockly.ALIGN_RIGHT).appendField("RX"); 
    //.appendField(Blockly.MIXLY_PIN);
    //this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    //this.setTooltip(Blockly.MU_INIT_TIPS1);
}
  };

  Blockly.Blocks['sentry_setawb'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_senpry.png", 60, 30))
          .appendField(Blockly.LKL_Sen2_VISION_TYPE1)
          .appendField(new Blockly.FieldDropdown(SEN_VISION_Awb), "VisionType");
      this.setPreviousStatement(true, null);
      this.setNextStatement(true, null);
      //this.setTooltip("启用或关闭00或Mu01对应列表里的算法功能。");
    },
  };

  
  Blockly.Blocks['sentry_setzoom'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_senpry.png", 60, 30))
          .appendField(Blockly.LKL_Sen2_VISION_TYPE2)
          .appendField(new Blockly.FieldDropdown(SEN_VISION_Zoom), "VisionType");
      this.setPreviousStatement(true, null);
      this.setNextStatement(true, null);
      //this.setTooltip("启用或关闭00或Mu01对应列表里的算法功能。");
    },
  };
  Blockly.Blocks['sentry_begin'] = {
    init: function() {
      var lVs2VisionStatus = [[Blockly.LKL_VS2_ENABLE, "Begin"],[Blockly.LKL_VS2_DISABLE, "End"]];
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(new Blockly.FieldImage("../../media/BT_Media/BT_senpry.png", 60, 30))
          .appendField(new Blockly.FieldDropdown(lVs2VisionStatus), "VisionStatus")
          .appendField(Blockly.LKL_Sen2_VISION_TYPE3)
          .appendField(new Blockly.FieldDropdown(SEN_VISION_TYPE), "VisionType");
      this.setPreviousStatement(true, null);
      this.setNextStatement(true, null);
      //this.setTooltip("启用或关闭00或Mu01对应列表里的算法功能。");
    },
  };

  Blockly.Blocks['Sentrydetect'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(Blockly.LKL_Sen2_VISION_TYPE3)
          .appendField(new Blockly.FieldDropdown(SEN_VISION_TYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };
  Blockly.Blocks['SenGetMessage'] = {
    init: function() {
      this.DETECTED_MESSAGE = [[Blockly.LKL_VS2_STATE_VALUE_X,"kXValue"], 
                              [Blockly.LKL_VS2_STATE_VALUE_Y,"kYValue"],
                              [Blockly.LKL_VS2_STATE_VALUE_WIDTH,"kWidthValue"], 
                              [Blockly.LKL_VS2_STATE_VALUE_HEIGHT,"kHeightValue"],
                              ];
      this.ColorRCGMessage = [[Blockly.LKL_VS2_STATE_VALUE_R_CHANNEL,"kRValue"],
                              [Blockly.LKL_VS2_STATE_VALUE_G_CHANNEL,"kGValue"],
                              [Blockly.LKL_VS2_STATE_VALUE_B_CHANNEL,"kBValue"],
                              [Blockly.LKL_VS2_STATE_VALUE_LABEL,"kLabel"]
                              ];
      var vision_type = SEN_VISION_TYPE.slice();
  
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(Blockly.LKL_Sen2_GET_DETECTED_MESSAGE)
          .appendField(Blockly.LKL_Sen2_VISION_TYPE3)
          .appendField(new Blockly.FieldDropdown(vision_type), "VisionType");
      this.vision_type_ = '';
      this.generateMessageType();
      this.setOutput(true, Number);
      this.setInputsInline(true);
      this.setTooltip("读取摄像头对应算法检测到的物体的坐标或宽度等值。");
    },
    onchange: function(e) {
      var vision_type = this.getFieldValue("VisionType");
      if (this.vision_type_ != vision_type) {
        if (this.vision_type_ == "Sentry::kVisionColorRecog"
          || vision_type == "Sentry::kVisionColorRecog") {
          this.generateMessageType();
        } else {
          this.vision_type_ = vision_type;
        }
      }
    },
    generateMessageType: function() {
      var type_index = -1;
      if (this.vision_type_ != '') {
        var last_message_type = this.getFieldValue("DETECTED_MESSAGE");
        var color_message = [];
        var other_message = [];
        for (var i = 0; i < this.ColorRCGMessage.length; i++) {
          color_message.push(this.ColorRCGMessage[i][1]);
        }
        for (var i = 0; i < this.DETECTED_MESSAGE.length; i++) {
          other_message.push(this.DETECTED_MESSAGE[i][1]);
        }
        if (color_message.indexOf(last_message_type) != -1) {
          type_index = color_message.indexOf(last_message_type);
        } else if (other_message.indexOf(last_message_type) != -1) {
          type_index = other_message.indexOf(last_message_type);
        }
      }
  
      this.vision_type_ = this.getFieldValue("VisionType");
      this.removeInput("DetectedMessage");
      if (this.vision_type_ == "Sentry::kVisionColorRecog") {
        this.appendDummyInput("DetectedMessage")
            .appendField(new Blockly.FieldDropdown(this.ColorRCGMessage), "DETECTED_MESSAGE")
            .appendField(Blockly.LKL_VS2_VALUE);
        if (type_index != -1) {
          if (type_index == this.DETECTED_MESSAGE.length-1) {
            this.setFieldValue(this.ColorRCGMessage[this.ColorRCGMessage.length-1][1], "DETECTED_MESSAGE");
          } else {
            this.setFieldValue(this.ColorRCGMessage[type_index][1], "DETECTED_MESSAGE");
          }
        }
      } else {
        this.appendDummyInput("DetectedMessage")
            .appendField(new Blockly.FieldDropdown(this.DETECTED_MESSAGE), "DETECTED_MESSAGE")
            .appendField(Blockly.LKL_VS2_VALUE);
        if (type_index != -1) {
          if (type_index == this.ColorRCGMessage.length-1) {
            this.setFieldValue(this.DETECTED_MESSAGE[this.DETECTED_MESSAGE.length-1][1], "DETECTED_MESSAGE");
          } else {
            this.setFieldValue(this.DETECTED_MESSAGE[type_index][1], "DETECTED_MESSAGE");
          }
        }
      }
    },
  };
  Blockly.Blocks['SenGetCardType'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测卡片内容');
          //.appendField(new Blockly.FieldDropdown(SEN_VISION_CARDTYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };

  Blockly.Blocks['SenGetCardTypet'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测卡片内容为：')
          .appendField(new Blockly.FieldDropdown(SEN_VISION_CARDTYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };
  
  Blockly.Blocks['SenGet20ClassType'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测物体');
          //.appendField(new Blockly.FieldDropdown(SEN_VISION_CARDTYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };
  Blockly.Blocks['SenGet20ClassType2'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测物体内容为：')
          .appendField(new Blockly.FieldDropdown(SEN_VISION_CLASSTYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };

  Blockly.Blocks['Otherlabeldetect'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField(Blockly.LKL_Sen2_VISION_TYPE3)
          .appendField(new Blockly.FieldDropdown(SEN_VISION_TYPE2), "VisionType")
          .appendField('标签');
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };
  Blockly.Blocks['SenGetBlob'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测色块颜色');
          //.appendField(new Blockly.FieldDropdown(SEN_VISION_CARDTYPE), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };
  Blockly.Blocks['SenGetBlob2'] = {
    init: function() {
      this.setColour(Blockly.makeColour(aicolor));
      this.appendDummyInput()
          .appendField('检测色块的颜色为：')
          .appendField(new Blockly.FieldDropdown(SEN_VISION_COLOR), "VisionType");
      this.setOutput(true, Number);
      //this.setTooltip("判断Mu00或Mu01对应算法功能是否被触发。");
    }
  };